package gov.va.genisis2.converter;

import java.util.ArrayList;
import java.util.List;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.genisis2.dto.CommentHistoryDTO;
import gov.va.genisis2.model.CommentHistory;

/**
 * This class is used to convert CommentHistoryDTO to CommentHistory entity and vice-versa.
 * 
 * @author PII
 *
 */
@Component
public class CommentHistoryConverter implements Converter<CommentHistory, CommentHistoryDTO> {

	@Override
	public CommentHistoryDTO convert(CommentHistory commentHistory) {
		CommentHistoryDTO commentHistoryDto = new CommentHistoryDTO();

		commentHistoryDto.setCommentId(commentHistory.getCommentId());
		commentHistoryDto.setComments(commentHistory.getComments());
		commentHistoryDto.setCreatedOn(commentHistory.getCreatedOn());
		commentHistoryDto.setCreatedBy(commentHistory.getCreatedBy());
		commentHistoryDto.setCommentType(commentHistory.getCommentType().getId());
		commentHistoryDto.setRequestId(commentHistory.getRequest().getId());
		commentHistoryDto.setStatus(commentHistory.getStatus());
		commentHistoryDto.setType(commentHistory.getType());
		
		

		return commentHistoryDto;
	}

	public CommentHistory convert(CommentHistoryDTO commentHistoryDto) {
		CommentHistory commentHistory = new CommentHistory();

		commentHistory.setCommentId(commentHistoryDto.getCommentId());
		commentHistory.setRequestId(commentHistoryDto.getRequestId());
		commentHistory.setStatus(commentHistoryDto.getStatus());
		commentHistory.setComments(commentHistoryDto.getComments());
		commentHistory.setCreatedBy(commentHistoryDto.getCreatedBy());
		commentHistory.setCommentTypeId(commentHistoryDto.getCommentType());

		return commentHistory;
	}
	
	public List<CommentHistoryDTO> convertCommentHistories(List<CommentHistory> commentHistories) {
		List<CommentHistoryDTO> commentHistoryDtos = null;
		
		if (null != commentHistories) {
			commentHistoryDtos = new ArrayList<>();
			for(CommentHistory CommentHistory : commentHistories) {
				commentHistoryDtos.add(convert(CommentHistory));
			}
		}
		
		return commentHistoryDtos;
	}
}
